﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using VeteransAffairs.Registries.BusinessAHOBPR;
using MI = VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using PS = VeteransAffairs.Registries.BusinessAHOBPR.PaymentService;

namespace WCF_BusinessManagerAHOBPRTests
{
    [TestClass]
    public class DeploymentFactoryTestBase
    {
        protected const string sqlConnection = "Data Source=DNS ;Initial Catalog=Registry_AHOBPRHRE;Integrated Security=True;Encrypt=yes";
        #region Deployments
        protected MI.DeploymentLocation CreateDeploymentLocation(string country, string beginDate, string endDate)
        {
            var location = new MI.DeploymentLocation
            {
                deploymentLocationBeginDate = DateTime.Parse(beginDate),
                deploymentLocationEndDate = DateTime.Parse(endDate),
            };
            if (Regex.IsMatch(country, "^\\d{1}")) 
            {
                location.deploymentLocationMajorBodyOfWaterCode = country;
            }else {
                location.deploymentCountry = country;
            }
            return location;
        }
        protected MI.DeploymentLocation[] CreateTwoDeploymentLocations()
        {
            var locOne = CreateDeploymentLocation("KU", "2006-07-29", "2006-07-30");
            var locTwo = CreateDeploymentLocation("IZ", "2006-01-12", "2006-05-13");
            return new MI.DeploymentLocation[] { locOne, locTwo };
        }
        #endregion
        /// <summary>
        /// DateRange from 2003-08-20 to 2010-08-13
        /// Branch of Service: A
        /// </summary>
        /// <returns></returns>
        protected Dictionary<DateRange, string> CreateSvcDateRange()
        {
            var svcEpisodeStart = DateTime.Parse("2003-08-20");
            var svcEpisodeEnd = DateTime.Parse("2010-08-13");
            var svcDateRange = new DateRange(svcEpisodeStart, svcEpisodeEnd);
            Dictionary<DateRange, string> svcEpisodes = new Dictionary<DateRange, string> { { svcDateRange, "A" } };
            return svcEpisodes;
        }
        /// <summary>
        /// DateRange from 2003-08-20 to 2010-08-13
        /// </summary>
        /// <returns></returns>
        protected Dictionary<DateRange, string> CreateSvcDateRange(string start, string end, string serviceBranch)
        {
            var svcEpisodeStart = DateTime.Parse(start);
            var svcEpisodeEnd = DateTime.Parse(end);
            var svcDateRange = new DateRange(svcEpisodeStart, svcEpisodeEnd);
            Dictionary<DateRange, string> svcEpisodes = new Dictionary<DateRange, string> { { svcDateRange, serviceBranch } };
            return svcEpisodes;
        }
        protected SortedDictionary<DateTime, List<ServiceSpecificOccupation>> CreateTwoOccupationHistoryEntries()
        {
            var dictionary = CreateSingleOccupationHistoryEntry();
            dictionary.Add(DateTime.Parse("7/31/2012 12:00:00 AM"),
                     new List<ServiceSpecificOccupation>{
                             new ServiceSpecificOccupation{
                                 OccupationId = 12638,
                                 StartDate = DateTime.Parse("7/31/2012 12:00:00 AM"),
                                 Type = 'P'
                             }
                     });

            return dictionary;
        }

        protected Dictionary<DateTime, PS.PayGradeHistoryData> CreateSinglePayGradeHistoryDataEntry()
        {
            return new Dictionary<DateTime, PS.PayGradeHistoryData>
            {
                { DateTime.Parse("2009-11-15"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "05",
                    serviceRankNameTxt = "Sergeant",
                    serviceRankNameCode = "SGT",
                    payGradeDate = DateTime.Parse("2009-11-15")
                } }
            };
        }

        protected Dictionary<DateTime, PS.PayGradeHistoryData> CreateTwoPayGradeHistoryDataEntries()
        {
            return new Dictionary<DateTime, PS.PayGradeHistoryData>
            {
                 { DateTime.Parse("2009-11-15"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "05",
                    serviceRankNameTxt = "Sergeant",
                    serviceRankNameCode = "SGT",
                    payGradeDate = DateTime.Parse("2009-11-15")
                } },
                { DateTime.Parse("2009-12-30"),
                new PS.PayGradeHistoryData
                {
                    payPlanCode = "ME",
                    PayGradeCode = "06",
                    serviceRankNameTxt = "Sergeant",
                    serviceRankNameCode = "SSGT",
                    payGradeDate = DateTime.Parse("2009-12-30")
                } }
            };
        }

        /// <summary>
        /// DateRange of 3/31/2014 12:00:00 AM" to DateTime Now. 
        /// Contains TWO (2) REGISTRANT_SERVICE_SPECIFIC_OCCUPATIONs
        /// </summary>
        /// <returns></returns>
        /// PaymentDataByDateTime
        protected SortedDictionary<DateTime, List<ServiceSpecificOccupation>> CreateSingleOccupationHistoryEntry()
        {
            return new SortedDictionary<DateTime, List<ServiceSpecificOccupation>>{
                { DateTime.Parse("3/31/2014 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId = 12638, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'P'}
                               ,new ServiceSpecificOccupation{OccupationId = 12767, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'S'}
                    }
                } };
        }
        protected SortedDictionary<DateTime, List<ServiceSpecificOccupation>> CreateEightOccupationHistoryEntries()
        {

            var x = new SortedDictionary<DateTime, List<ServiceSpecificOccupation>>{
                { DateTime.Parse("3/31/2014 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId= 12638, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'P'}
                               ,new ServiceSpecificOccupation{OccupationId= 12767, StartDate = DateTime.Parse("3/31/2014 12:00:00 AM"), Type = 'S'}
                    }
                },
                { DateTime.Parse("7/31/2012 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId= 12638, StartDate = DateTime.Parse("7/31/2012 12:00:00 AM"), Type = 'P'}
                        }
                },
                { DateTime.Parse("10/31/2010 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId= 12638, StartDate = DateTime.Parse("10/31/2010 12:00:00 AM"), Type = 'D'}
                        }
                },
                { DateTime.Parse("11/30/2007 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId= 12586, StartDate = DateTime.Parse("11/30/2007 12:00:00 AM"), Type = 'P'}
                           }
                },
                { DateTime.Parse("9/30/2005 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                            new ServiceSpecificOccupation{OccupationId= 12638, StartDate = DateTime.Parse("9/30/2005 12:00:00 AM"), Type = 'P'}
                        }
                },
                { DateTime.Parse("8/31/2003 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                            new ServiceSpecificOccupation{OccupationId= 13043, StartDate = DateTime.Parse("8/31/2003 12:00:00 AM"), Type = 'P'}
                        }
                },
                { DateTime.Parse("5/31/2003 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                                new ServiceSpecificOccupation{OccupationId= 13343, StartDate = DateTime.Parse("5/31/2003 12:00:00 AM"), Type = 'P' }
                        }
                },
                { DateTime.Parse("3/25/2003 12:00:00 AM"),
                        new List<ServiceSpecificOccupation>{
                            new ServiceSpecificOccupation{OccupationId= 13819, StartDate = DateTime.Parse("3/25/2003 12:00:00 AM"), Type = 'P'}
                        }
                }
        };
            return x;
        }
        //protected SortedDictionary<DateTime, List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>> CreateEightOccupationHistoryEntries()
        //{

        //    var x = new SortedDictionary<DateTime, List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>>{
        //        { DateTime.Parse("3/31/2014 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                        new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 12638, START_DATE = DateTime.Parse("3/31/2014 12:00:00 AM"), OCCUPATION_TYPE = 'P'}
        //                       ,new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 12767, START_DATE = DateTime.Parse("3/31/2014 12:00:00 AM"), OCCUPATION_TYPE = 'S'}
        //            }
        //        },
        //        { DateTime.Parse("7/31/2012 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                        new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 12638, START_DATE = DateTime.Parse("7/31/2012 12:00:00 AM"), OCCUPATION_TYPE = 'P'}
        //                }
        //        },
        //        { DateTime.Parse("10/31/2010 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                        new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 12638, START_DATE = DateTime.Parse("10/31/2010 12:00:00 AM"), OCCUPATION_TYPE = 'D'}
        //                }
        //        },
        //        { DateTime.Parse("11/30/2007 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                        new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 12586, START_DATE = DateTime.Parse("11/30/2007 12:00:00 AM"), OCCUPATION_TYPE = 'P'}
        //                   }
        //        },
        //        { DateTime.Parse("9/30/2005 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                    new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 12638, START_DATE = DateTime.Parse("9/30/2005 12:00:00 AM"), OCCUPATION_TYPE = 'P'}
        //                }
        //        },
        //        { DateTime.Parse("8/31/2003 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                    new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 13043, START_DATE = DateTime.Parse("8/31/2003 12:00:00 AM"), OCCUPATION_TYPE = 'P'}
        //                }
        //        },
        //        { DateTime.Parse("5/31/2003 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                        new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 13343, START_DATE = DateTime.Parse("5/31/2003 12:00:00 AM"), OCCUPATION_TYPE = 'P' }
        //                }
        //        },
        //        { DateTime.Parse("3/25/2003 12:00:00 AM"),
        //                new List<REGISTRANT_SERVICE_SPECIFIC_OCCUPATION>{
        //                    new REGISTRANT_SERVICE_SPECIFIC_OCCUPATION{STD_SERVICE_OCCUPATION_ID = 13819, START_DATE = DateTime.Parse("3/25/2003 12:00:00 AM"), OCCUPATION_TYPE = 'P'}
        //                }
        //        }
        //};
        //    return x;
        //}
    }
}
